package gov.va.med.mhv.common.api.enumeration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public enum StateEnum {

	ALABAMA("AL","Alabama"), 
	ALASKA("AK", "Alaska"), 
	AMERICAN_SAMOA( "AS", "American Samoa"), 
	ARIZONA( "AZ","Arizona"), 
	ARKANSAS( "AR", "Arkansas"), 
	CALIFORNIA("CA", "California"), 
	COLORADO( "CO", "Colorado"), 
	CONNECTICUT( "CT", "Connecticut"), 
	DELAWARE( "DE","Delaware"), 
	DISTRICT_OF_COLUMBIA( "DC", "District of Columbia"), 
	FEDERATED_STATES_OF_MICRONESIA( "FM", "Federated States of Micronesia"), 
	FLORIDA("FL", "Florida"), 
	GEORGIA( "GA", "Georgia"), 
	GUAM( "GU","Guam"), 
	HAWAII( "HI", "Hawaii"), 
	IDAHO( "ID", "Idaho"), 
	ILLINOIS( "IL", "Illinois"), 
	INDIANA( "IN", "Indiana"), 
	IOWA( "IA","Iowa"), 
	KANSAS( "KS", "Kansas"), 
	KENTUCKY( "KY", "Kentucky"), 
	LOUISIANA( "LA", "Louisiana"), 
	MAINE( "ME","Maine"), 
	MARYLAND( "MD", "Maryland"), 
	MARSHALL_ISLANDS( "MH", "Marshall Islands"), 
	MASSACHUSETTS( "MA","Massachusetts"), 
	MICHIGAN( "MI", "Michigan"), 
	MINNESOTA( "MN", "Minnesota"), 
	MISSISSIPPI( "MS", "Mississippi"), 
	MISSOURI( "MO", "Missouri"), 
	MONTANA( "MT", "Montana"), 
	NEBRASKA( "NE", "Nebraska"), 
	NEVADA("NV", "Nevada"), 
	NEW_HAMPSHIRE( "NH", "New Hampshire"), 
	NEW_JERSEY( "NJ", "New Jersey"), 
	NEW_MEXICO( "NM", "New Mexico"), 
	NEW_YORK( "NY", "New York"), 
	NORTH_CAROLINA( "NC", "North Carolina"), 
	NORTH_DAKOTA( "ND", "North Dakota"), 
	NORTHERN_MARIANA_ISLANDS( "MP", "Northern Mariana Islands"), 
	OHIO("OH", "Ohio" ), 
	OKLAHOMA( "OK", "Oklahoma"), 
	OREGON( "OR", "Oregon"), 
	PALAU("PW", "Palau"), 
	PENNSYLVANIA( "PA", "Pennsylvania"), 
	PUERTO_RICO( "PR", "Puerto Rico"), 
	RHODE_ISLAND( "RI", "Rhode Island"), 
	SOUTH_CAROLINA( "SC", "South Carolina"), 
	SOUTH_DAKOTA( "SD", "South Dakota"), 
	TENNESSEE( "TN", "Tennessee"), 
	TEXAS( "TX", "Texas"), 
	UTAH("UT", "Utah"), 
	VERMONT( "VT", "Vermont"), 
	VIRGIN_ISLANDS( "VI", "Virgin Islands"), 
	VIRGINIA( "VA", "Virginia"), 
	WASHINGTON( "WA", "Washington"), 
	WEST_VIRGINIA( "WV", "West Virginia"), 
	WISCONSIN( "WI", "Wisconsin"), 
	WYOMING( "WY", "Wyoming"), 
	UNKNOWN( "", "Unknown")
	;

	private String stateCode;
	private String stateDetailName;

	private static final Map<String, StateEnum> STATES_BY_CODE = new HashMap<String, StateEnum>();
	public static final Map<String, String> STATES_BY_DETAIL = new TreeMap<String, String>();

	/* static initializer */
	static {
		for (StateEnum stateEn : values()) {
			STATES_BY_CODE.put(stateEn.getStateCode(), stateEn);
			STATES_BY_DETAIL.put(stateEn.getStateCode(), stateEn.getStateDetailName());
		}
	}

	private StateEnum() {
	}

	private StateEnum(String stateCode, String stateDetailName){
		this.stateCode = stateCode;
		this.stateDetailName = stateDetailName;

	}

	public static StateEnum valueOfAbbreviation(final String stateCode) {
		final StateEnum stateEn = STATES_BY_CODE.get(stateCode);
		if (stateEn != null) {
			return stateEn;
		} else {
			return UNKNOWN;
		}
	}
	public static List<StateEnum> toList(){
		return Arrays.asList(StateEnum.values());
	}
	
	public static List<StateEnum> toDetailList(){
		return Arrays.asList(StateEnum.values());
	}
	public String getStateCode() {
		return stateCode;
	}

	public void setStateCode(String stateCode) {
		this.stateCode = stateCode;
	}

	public String getStateDetailName() {
		return stateDetailName;
	}

	public void setStateDetailName(String stateDetailName) {
		this.stateDetailName = stateDetailName;
	}

	public String toString() {
		return this.stateDetailName;
	}

}
